library("dplyr")
library("readxl")
library("ggplot2")
library("sf")

archivo_entrada = "a. IF_C.xlsx"
mapa_salida = "b. IFC_mapa.png"
histograma_salida = "c. IFC_histograma.png"

DATA <- read_excel(archivo_entrada)
DATA <- mutate(DATA, IHH_PREVIO=ifelse(IHH_PREVIO==0, NA, IHH_PREVIO))

SF <- st_read("MGN_ADM_MPIO_GRAFICO.shp")
SF$ID_MUNICIPIO <- as.numeric(SF$mpio_cdpmp)
SF <- merge(SF, select(DATA, ID_MUNICIPIO, IHH_PREVIO), by = "ID_MUNICIPIO", sort = FALSE, all.x = TRUE)

base_map <- ggplot(data = SF) +
  geom_sf(aes(fill = IHH_PREVIO), color = NA) +
  scale_fill_gradient(low = "white", high = "darkred", limits = c(0, 1)) +
  theme_minimal() + labs(fill = "IHH")

san_andres_map <- ggplot(data = SF) +
  geom_sf(aes(fill = IHH_PREVIO), color = NA) +
  scale_fill_gradient(low = "white", high = "darkred", limits = c(0, 1)) +
  coord_sf(xlim = c(-81.8, -81.3), ylim = c(12.45, 12.65), expand = TRUE) +
  theme_void() + theme(legend.position = "none")

san_andres_grob <- ggplotGrob(san_andres_map)

final_map <- base_map +
  annotation_custom(
    grob = san_andres_grob,
    xmin = -82, xmax = -72, ymin = 2, ymax = 20)

print(final_map)

ggsave(mapa_salida, plot = final_map, width = 14, height = 12, dpi = 300)

